/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerWorkflowPane;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMWorkflowListPanel;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMWorkflowPropertiesPanel;
import filenet.vw.toolkit.design.property.event.IVWMapChangedListener;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.utils.VWSplitPane;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.JPanel;

public class VWSIMWorkflowsTab
extends JPanel
implements IVWMapChangedListener {
    protected VWSIMWorkflowListPanel m_workflowListPanel = null;
    protected VWSIMDesignerWorkflowPane m_mapPanel = null;
    protected VWSIMWorkflowPropertiesPanel m_propertiesPanel = null;
    protected VWSIMPropertyData m_propertyData = null;

    public void init(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.m_workflowListPanel = new VWSIMWorkflowListPanel(this.m_propertyData);
        this.m_mapPanel = new VWSIMDesignerWorkflowPane(this.m_propertyData);
        this.m_propertiesPanel = new VWSIMWorkflowPropertiesPanel();
        this.m_propertiesPanel.init(this.m_propertyData, this.m_mapPanel);
        this.setLayout(new BorderLayout());
        Locale browserLocale = this.m_propertyData.getSessionInfo().getBrowserLocale();
        ComponentOrientation compOrientation = null;
        compOrientation = browserLocale != null ? ComponentOrientation.getOrientation(browserLocale) : ComponentOrientation.LEFT_TO_RIGHT;
        if (compOrientation.isLeftToRight()) {
            VWSplitPane splitPane1 = new VWSplitPane(1, this.m_workflowListPanel, this.m_mapPanel);
            splitPane1.setOneTouchExpandable(true);
            splitPane1.setDividerLocation(0.2);
            splitPane1.setDividerSize(6);
            splitPane1.setResizeWeight(0.5);
            VWSplitPane splitPane2 = new VWSplitPane(1, splitPane1, this.m_propertiesPanel);
            splitPane2.setOneTouchExpandable(true);
            splitPane2.setDividerLocation(0.65);
            splitPane2.setDividerSize(6);
            splitPane2.setResizeWeight(0.5);
            this.add((Component)splitPane2, "Center");
        } else {
            VWSplitPane splitPane1 = new VWSplitPane(1, this.m_propertiesPanel, this.m_mapPanel);
            splitPane1.setOneTouchExpandable(true);
            splitPane1.setDividerLocation(0.35);
            splitPane1.setDividerSize(6);
            splitPane1.setResizeWeight(0.5);
            VWSplitPane splitPane2 = new VWSplitPane(1, splitPane1, this.m_workflowListPanel);
            splitPane2.setOneTouchExpandable(true);
            splitPane2.setDividerLocation(0.8);
            splitPane2.setDividerSize(6);
            splitPane2.setResizeWeight(0.5);
            this.add((Component)splitPane2, "Center");
        }
        this.m_mapPanel.addItemListener(this.m_propertiesPanel.getListener());
        this.m_propertyData.getMapChangeEventNotifier().addMapChangedListener(this);
    }

    public void importWorkflow() {
        if (this.m_workflowListPanel != null) {
            this.m_workflowListPanel.importWorkflow();
        }
    }

    public void replaceWorkflow() {
        if (this.m_workflowListPanel != null) {
            this.m_workflowListPanel.replaceWorkflow();
        }
    }

    public void deleteSelectedWorkflow() {
        if (this.m_workflowListPanel != null) {
            this.m_workflowListPanel.deleteSelectedWorkflow();
        }
    }

    public String getSelectedWorkflowName() {
        if (this.m_workflowListPanel != null) {
            return this.m_workflowListPanel.getSelectedWorkflowName();
        }
        return null;
    }

    public VWMapAttribs getMapAttributes() {
        if (this.m_mapPanel != null) {
            return this.m_mapPanel.getMapAttributes();
        }
        return null;
    }

    public void releaseReferences() {
        this.m_workflowListPanel = null;
        this.m_mapPanel = null;
        this.m_propertiesPanel = null;
        this.m_propertyData = null;
    }

    public void mapChanged(VWMapChangedEvent event) {
        switch (event.getID()) {
            case 554: {
                this.m_mapPanel.setWorkflowDefinition(this.m_propertyData.getSelectedWorkflowDefinition(), null);
            }
        }
    }
}

